;
;***********************
;  DEMO STEPPING MOTOR *
;     EXPERIMENT 6     *
;***********************
;
           CPU  "Z180.TBL"
           HOF  "INT8"

           ORG  8000H
STPXY:     EQU  0B5H
STPCRTL:   EQU  0B7H
SCANK:     EQU  0102H
GOTO_ADDR: EQU  010DH
HBEEP:     EQU  0149H
DMSEC:     EQU  012EH
PRINT:     EQU  0126H
SYSFAG:    EQU  0FDEFH       ;RESET SOUND
;
LEFT:      EQU  4
RIGHT:     EQU  5
UP:        EQU  2
DOWN:      EQU  3
ENT:       EQU  0DH

;
START:   LD   A,10011001B
         OUT  (STPCRTL),A

         LD   DE,TAB_DSP
         CALL PRINT

         LD   A,99H          ;Start phase X,Y
         LD   (PHASEX),A
         LD   (PHASEY),A
         LD   IY,BUFXY
         LD   IX,0
;
MAIN:    LD   HL,0
         LD   (CONTX),HL     ;initial step x,y
         LD   (CONTY),HL
         XOR  A
         OUT  (STPXY),A
         LD   (FLAG_R),A
         LD   HL,SYSFAG      ;RESET  SOUND
         SET  3,(HL)
;
MAIN2:   CALL SCANK
         CP   0FFH
         JR   Z,MAIN2
;
         CP   UP
         JP   Z,STEPX
         CP   DOWN
         JP   Z,STEPY
         JR   MAIN2
;
STEPX:   LD   D,0FH
         CALL GOTO_ADDR
         CALL SCANK
         CP   RIGHT
         CALL Z,PRGXR
         CP   LEFT
         CALL Z,PRGXL
         CP   DOWN
         JP   Z,STEPY
         CP   ENT
         JP   Z,X_PRG
         CP   0FFH
         JR   NZ,STEPX
         XOR  A
         OUT  (STPXY),A
         JR   STEPX
;
X_PRG:   CALL KEY_OK
         LD   A,(FLAG_R)
         CP   0
         JR   Z,X_RUN
         CALL PRG_MEM
         JR   STEPX
;
X_RUN:   CALL PRG_RUN
         JP   START


STEPY:   LD   D,4FH
         CALL GOTO_ADDR
         CALL SCANK
         CP   RIGHT
         CALL Z,PRGYR
         CP   LEFT
         CALL Z,PRGYL
         CP   UP
         JP   Z,STEPX
         CP   ENT
         JP   Z,Y_PRG
         CP   0FFH
         JR   NZ,STEPY
         XOR  A
         OUT  (STPXY),A
         JR   STEPY
;
Y_PRG:   CALL KEY_OK
         LD   A,(FLAG_R)
         CP   0
         JR   Z,Y_RUN
         CALL PRG_MEM
         JR   STEPY
;
Y_RUN:   CALL PRG_RUN
         JP   START

;/* Check mem release */

KEY_OK:  CALL HBEEP            ;PROGRAM
KEY_OK1: CALL SCANK
         CP   ENT
         JR   Z,KEY_OK1
         RET
;
;***********************
;   PROGRAM MOVE X,Y   *
;***********************
;
PRGXR:   PUSH AF
         CALL PHASXL
         LD   HL,FLAG_R
         SET  0,(HL)
         LD   HL,(CONTX)
         INC  HL
         LD   (CONTX),HL
         CALL ENGISE
         POP  AF
         RET
;
PRGXL:   PUSH AF
         CALL PHASXR
         LD   HL,FLAG_R
         SET  0,(HL)
         LD   HL,(CONTX)
         DEC  HL
         LD   (CONTX),HL
         CALL ENGISE
         POP  AF
         RET
;
PRGYR:   PUSH AF
         CALL PHASYL
         LD   HL,FLAG_R
         SET  0,(HL)
         LD   HL,(CONTY)
         INC  HL
         LD   (CONTY),HL
         CALL ENGISE1
         POP  AF
         RET
;
PRGYL:   PUSH AF
         CALL PHASYR
         LD   HL,FLAG_R
         SET  0,(HL)
         LD   HL,(CONTY)
         DEC  HL
         LD   (CONTY),HL
         CALL ENGISE1
         POP  AF
         RET
;
;/* MEM X,Y  */

PRG_MEM: INC  IX
         LD   HL,(CONTX)
         LD   (IY+0),L       ;stroe x to buff
         INC  IY
         LD   (IY+0),H
         INC  IY
         LD   HL,(CONTY)
         LD   (IY+0),L       ;stroe y to buff
         INC  IY
         LD   (IY+0),H
         INC  IY             ;next pointer
;
         LD   HL,0
         LD   (CONTX),HL     ;CLEAR step x,y
         LD   (CONTY),HL
         LD   HL,FLAG_R
         RES  0,(HL)
         RET
;
;
;***********************
;   PROGRAM RUN  X,Y   *
;***********************
;
PRG_RUN: LD   DE,TAB_RUN
         CALL PRINT

         PUSH IX
         POP  HL
         LD   A,L
         OR   H
         JR   Z,RUN_EXIT
         LD   IY,BUFXY
;
;/* step X left execute */

RUNX_RL: CALL RD_DAT
         JP   Z,RUNY_RL
         JP   M,RUN_XR
;
RUN_XL:  CALL PHASXL
         CALL ENGISE
         DEC  DE
         LD   A,D
         OR   E
         JR   NZ,RUN_XL
         JR   RUNY_RL
;
;/* step X right execute */

RUN_XR:  CALL NUM_MINUS
RUN_XR1: CALL PHASXR
         CALL ENGISE
         DEC  DE
         LD   A,D
         OR   E
         JR   NZ,RUN_XR1
;
;/* Step Y left execute */

RUNY_RL: CALL RD_DAT
         JR   Z,EN_1PRG
         JP   M,RUN_YR

RUN_YL:  CALL PHASYL
         CALL ENGISE1
         DEC  DE
         LD   A,E
         OR   A
         JR   NZ,RUN_YL
         JR   EN_1PRG
;
;/* Step Y right execute */

RUN_YR:  CALL NUM_MINUS
RUN_YR1: CALL PHASYR
         CALL ENGISE1
         DEC  DE
         LD   A,D
         OR   E
         JR   NZ,RUN_YR1
;
;/* End 1 program */

EN_1PRG: CALL HBEEP
         CALL DELAY
         DEC  IX
         PUSH IX
         POP  HL
         LD   A,H
         OR   L
         JP   NZ,RUNX_RL
RUN_EXIT:
         RET

;
;***********************
;    READ BUFFER X,Y   *
;***********************

RD_DAT:  LD   E,(IY+0)
         INC  IY
         LD   D,(IY+0)
         INC  IY
         LD   A,D
         OR   E
         RET
;
;***********************
; CHANGE MINUS TO PLUS *
;***********************

NUM_MINUS:
         LD   A,D
         CPL
         LD   D,A
         LD   A,E
         CPL
         LD   E,A
         LD   HL,1
         ADD  HL,DE
         EX   DE,HL
         RET

;***********************
;  CONTROL PHASE X ->  *
;***********************
;
PHASXL:  LD   A,(PHASEX)
         RLCA
         LD   (PHASEX),A
         RET
;
;***********************
;  CONTROL PHASE X <-  *
;***********************
;
PHASXR:  LD   A,(PHASEX)
         RRCA
         LD   (PHASEX),A
         RET
;
;***********************
;  CONTROL PHASE Y  ^  *
;***********************
;
PHASYL:  LD   A,(PHASEY)
         RLCA
         LD   (PHASEY),A
         RET
;
;***********************
;  CONTROL PHASE Y  _  *
;***********************
;
PHASYR:  LD   A,(PHASEY)
         RRCA
         LD   (PHASEY),A
         RET
;
;
;***********************
;     ENERGISE PHASE   *
;***********************
;
;*** phase x,y -> ***

ENGISE:  AND 0FH
         OUT  (STPXY),A
         CALL DELAY
         RET
;
;*** phase x,y <- ***

ENGISE1: AND  0F0H
         OUT  (STPXY),A
         CALL DELAY
         RET
;
;
;*** DELAY SUB ***

DELAY:   LD   B,20
         CALL DMSEC
         RET
;
TAB_DSP: DFB  " Program Step X "
         DFB  " Program Step Y ",0
TAB_RUN: DFB  "RUN PROGRAM X,Y ",0

;*** RAM AREA ***

        ORG  0F000H
BUFXY:  DFS  0F00H
CONTX:  DFS   2
CONTY:  DFS   2
PHASEX: DFS   1
PHASEY: DFS   1
PHASEZ: DFS   1
FLAG_R: DFS   1
        END

;
